#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/shm.h>
#include <sys/msg.h>
#include <unistd.h>
#include <time.h>
#include <signal.h>
#include <sys/wait.h>
#include <string.h>
typedef struct poruka{
    long tip;
    int operacija;
    int rezultat;
}PorukaKorisnik;

typedef struct {
    long tip;
    int operacija;
    int rednibroj;
}PorukaRadniCvor;

enum{PRISTUP_KORISNIK, PRIJAVA_RC, ZARSENI_ZADACI_RC, MUTEXDELJENA};

union semun {
               int              val;    /* Value for SETVAL */
               struct semid_ds *buf;    /* Buffer for IPC_STAT, IPC_SET */
               unsigned short  *array;  /* Array for GETALL, SETALL */
               struct seminfo  *__buf;  /* Buffer for IPC_INFO
                                           (Linux-specific) */
}arg;
#define TIP_KORISNK 444
#define TIP_GLAVNICVOR 555
#define TIP_RADNICVOR 666
#define msgsize sizeof(PorukaKorisnik)-sizeof(long)

   
struct sembuf P_PRISTUP_KORISNIK = {PRISTUP_KORISNIK, -1,0};
struct sembuf V_PRISTUP_KORISNIK = {PRISTUP_KORISNIK, 1,0};
struct sembuf PMUTEX = {MUTEXDELJENA, -1,0};
struct sembuf VMUTEX = {MUTEXDELJENA, 1,0};

int main(){

    key_t key = ftok("/init.c",1);

    int msgid = msgget(key, IPC_CREAT | 0666);
    int shmid = shmget(key, 12*sizeof(int), IPC_CREAT | 0666);
    int semid = semget(key,5 ,IPC_CREAT | 0666);

    int *niz = (int*)shmat(shmid, NULL,0);

    PorukaKorisnik poruka;
   printf("Korisnik: Cekam na pristup klasteru..\n");
    semop(semid, &P_PRISTUP_KORISNIK,1);
    printf("Korisnik: Dobio sam pristup, generisem niz\n");
    semop(semid, &PMUTEX, 1);
     for(int i=0; i<12;i++){
       niz[i] = rand()%30;
        
    }
    semop(semid, &VMUTEX,1);
    poruka.tip = TIP_GLAVNICVOR;
    poruka.operacija = rand()%4;

    string op[8]= "";
     if(poruka.operacija==0){
            op = "SUMA";
        }
        else if(poruka.operacija==1){
             op = "PROIZVOD";
        }
       else if(poruka.operacija==2){
         op = "MINIMUM";}
        else 
           {
              op = "MAKSIMUM";
           }

    printf("Korisnik: Niz i operacija %s spremni\n", op);
     msgsnd(msgid, &poruka, msgsize, 0);
      printf("Korisnik: Cekam rezultat..\n");
    msgrcv(msgid, &poruka, msgsize, TIP_KORISNK, 0);
    printf("Korisnik: Rezultat je %d, zavrsvam.\n", poruka.rezultat);
     semop(semid, &V_PRISTUP_KORISNIK,1);
     exit(0);
   
}